/*==============================================================================

                                    O  F  E  L  I

                           Object  Finite  Element  Library

  ==============================================================================

   Copyright (C) 1998 - 2024 Rachid Touzani

   This file is part of OFELI.

   OFELI is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   OFELI is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with OFELI. If not, see <http://www.gnu.org/licenses/>.

  ==============================================================================

                            Definition of class 'Fct'
                    Class to define functions by an expression

  ==============================================================================*/

#ifndef __FCT_H
#define __FCT_H

#include <string>
#include <vector>
using std::string;
using std::vector;

#include "OFELI_Config.h"
#include "linear_algebra/Point.h"
#include "linear_algebra/SpaceTime.h"

namespace exprtk {
   template <typename T> class parser;
   template <typename T> class expression;
   template <typename T> class expression_helper;
   template <typename T> class symbol_table;
}

#ifndef DOXYGEN_SHOULD_SKIP_THIS

namespace OFELI {
/*!
 *  \addtogroup OFELI
 *  @{
 */

class Fct {

 public:

   Fct();
   Fct(const string& exp, const vector<string>& v);
   Fct(const string& exp);
   Fct(const string& exp, const string& v);
   Fct(const string& n, const string& exp, const vector<string>& v);
   ~Fct();
   string getErrorMessage();
   int set(const string& exp, const vector<string>& v, int opt=0);
   int set(const string& exp, int opt=0);
   int set(const string& exp, const string &v, int opt=0);
   int set(const string& n, const string &exp, const vector<string>& v, int opt=0);
   void setVar(const string& v);
   void setVar(const vector<string>& v);
   void setName(const string& n) { _name = n; }
   real_t operator()(real_t x);
   real_t operator()(real_t x, real_t y);
   real_t operator()(real_t x, real_t y, real_t z);
   real_t operator()(real_t x, real_t y, real_t z, real_t t);
   real_t operator()(const Point<real_t>& x);
   real_t operator()(const Point<real_t>& x, real_t t);
   real_t operator()(const SpaceTime& p);
   real_t operator()(const vector<real_t>& x);
   string getExpression() const;
   string getName() const { return _name; }
   size_t getNbVar() const { return _nb_var; }
   string getVar(size_t i) const { return _var[i-1]; }
   real_t D(real_t x);
   real_t D(const vector<real_t>& x, size_t i);
   int check();
   int getErrorCode() const;
   friend std::ostream& operator<<(std::ostream& s, const Fct& f);

 private:

   exprtk::parser<real_t> *_p;
   exprtk::symbol_table<real_t> *_st;
   exprtk::expression<real_t> *_ex;
   vector<real_t> _xvar;
   void add_constants();
   string _name;
   size_t _nb_var;
   bool _exp_ok, _var_ok;
   int err;
   vector<string> _var;
   string _expr, error_message;
};

} /* namespace OFELI */
/*! @} End of Doxygen Groups */
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#endif