/*==============================================================================

                             *************************
                             *     L E L A S 2 D     *
                             *************************

                A Finite Element Code for Linearized Elastostatics in
                                  Two Dimensions

  ------------------------------------------------------------------------------

   Copyright (C) 1998 - 2026 Rachid Touzani

   This file is part of OFELI.

   OFELI is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   OFELI is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with OFELI. If not, see <http://www.gnu.org/licenses/>.

  ==============================================================================*/


#include "OFELI.h"
#include "Solid.h"
using namespace OFELI;

int main(int argc, char *argv[])
{
   if (argc < 2) {
      cout << "\nUsage: " << argv[0] << " <parameter_file>\n";
      return EXIT_FAILURE;
   }

   IPF data("lelas2d - 1.1 ",argv[1]);
   Verbosity = data.getVerbose();
   int save_flag = data.getSave();

   if (Verbosity) {
      cout << endl << endl;
      cout << "    *******************************************************\n";
      cout << "    *                   L E L A S 2 D                     *\n";
      cout << "    *     Two-Dimensional Linearized Elastostatics        *\n";
      cout << "    *******************************************************\n\n\n";
      cout << "=====================================================================\n\n";
      cout << "         A Finite Element Code for Linearized Elastostatics\n";
      cout << "                             in 2-D Geometries\n\n";
      cout << "            LELAS2D uses OFELI Library of Finite Element Classes\n\n";
      cout << "                           V E R S I O N   1.0\n\n";
      cout << "                       Copyright R. Touzani, 1998\n\n";
      cout << "=====================================================================\n\n";
   }

// Read Mesh data
   try {
      if (Verbosity > 1)
         cout << "Reading mesh data ...\n";
      Mesh ms(data.getMeshFile(1),true);
      Prescription p(ms,data.getDataFile());
      if (Verbosity > 5)
         cout << ms;

//    Read boundary conditions, body and boundary forces
      Vect<double> u(ms), bound_f(ms,2,BOUNDARY_SIDE_DOF);
      if (Verbosity > 1)
         cout << "Reading Boundary Tractions ..." << endl;
      p.getTraction(bound_f);

//    Declare equation instance and solve
      if (Verbosity > 1)
         cout << "Setting and solving equation ...\n";
      Elas2DQ4 eq(ms,u);
      eq.setBoundaryCondition(p.getBoundaryCondition());
      eq.setBodyForce(p.getBodyForce());
      eq.setTraction(bound_f);
      eq.run();

//    Output and save solution
      if (Verbosity > 3)
         cout << u;
      if (save_flag) {
         IOField pl_file(data.getPlotFile(),IOField::OUT);
         pl_file.put(u);
      }

//    Calculate principal and Von-Mises stresses
      if (Verbosity > 1)
         cout << "Calculating stresses ...\n";
      Vect<double> st, vm;
      eq.Stress(st,vm);
   } CATCH_EXCEPTION
   return EXIT_SUCCESS;
}
